using System;
using System.Collections;
using Method = System.Reflection.MethodBase;
using System.Drawing.Printing;
using System.Data;
using System.Text;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Summary description for TransfusionComplicationsReport.</summary>

		#endregion

	public class TransfusionComplicationsReport:VbecsReport
	{
		#region Variables

		private DataTable _transfusionComplictionsReport;
		private DataTable _transfusedUnits;
		private DataTable _labTestResults;
		private ArrayList _labTestArray;
		private DataTable _labTests;
        private DataSet _dsReport = new DataSet();
		#endregion

		#region Consructors

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5459"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Initialized TransfusionComplications object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5460"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TransfusionComplicationsReport
		/// </summary>
		public TransfusionComplicationsReport()
		{
			GetLabTests();
		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5465"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5466"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets transfusion complications report data table for use in report
		/// </summary>
		public DataTable DetailedReport
		{
			get
			{
				if (this._transfusionComplictionsReport == null)
				{
					this.GetTransfusionComplicationsReport();
				}
				return this._transfusionComplictionsReport;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5463"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Report criteria string for report footer</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5464"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets report criteria text for Transfusion Complications report footer
		/// </summary>
		public string ReportCriteria
		{
			get
			{
				StringBuilder criteria = new StringBuilder();
				criteria.Append("Start Date: "+Common.VBECSDateTime.FormatDateString(this.StartDate)+"\n");
				criteria.Append("End Date: "+Common.VBECSDateTime.FormatDateTimeString(this.EndDate)+"\n");
				criteria.Append("Transfusion Start Date: "+Common.VBECSDateTime.FormatDateString(this.TransfusionStartDate)+"\n");
				criteria.Append("Transfusion End Date: "+Common.VBECSDateTime.FormatDateTimeString(this.TransfusionEndDate)+"\n");
				//
				return criteria.ToString();
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5476"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5477"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets patient transfusion start date - used in UC 90
		/// </summary>
		public DateTime TransfusionStartDate
		{
			get
			{
				return Convert.ToDateTime(this.ParameterRow[ARTIFICIAL.TransfusionStartDate]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.TransfusionStartDate] = value.Date;
			}
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5478"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5479"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets patient transfusion end date - used in UC 90
		/// </summary>
		public DateTime TransfusionEndDate
		{
			get
			{
				return Convert.ToDateTime(this.ParameterRow[ARTIFICIAL.TransfusionEndDate]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.TransfusionEndDate] = value.Date.AddHours(23).AddMinutes(59).AddSeconds(59);
			}
		}

		#endregion


		#region Methods

		///<Developers>
		///	<Developer>Margret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5461"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DetailedReport has data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5462"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Load transfusion complications report for report
		/// </summary>
		public void GetTransfusionComplicationsReport()
		{
			DataTable dtReport = this.GetTransfusionComplicationsReportSchema();
			//
			if (this._labTestArray.Count==0)
			{
				this._transfusionComplictionsReport = dtReport.Clone();
				return;
			}
			//
			_transfusedUnits = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(this.TransfusionStartDate, this.TransfusionEndDate);
			//
			//Holds IDs of patients with transfusions and lab test results within date range
			ArrayList patientLabTestArray = new ArrayList();
			//
			try
			{
				//Holds IDs of all patients with transfusions - to use when searching VistA for Lab Test results.
				ArrayList patientTransfusionArray = this.GetPatientArray();
				if (patientTransfusionArray.Count > 0)
				{
					_labTestResults = BOL.LabTest.GetVistALabTestResults(this.StartDate, this.EndDate, Common.LogonUser.LogonUserDivisionCode, this._labTestArray, patientTransfusionArray);
					//
					foreach(DataRow dr in _labTestResults.Rows)
					{
						if (!this.IncludeTestInReport(dr))
						{
							continue;
						}
						DataRow drReport = dtReport.NewRow();
						//
						DataRow drPatient = FindPatientInfo(dr[TABLE.Patient.VistaPatientId].ToString());
						//
						//Add patient to array of patients with transfusions and lab test results - if not already in the list
						if (patientLabTestArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
						{
							patientLabTestArray.Add(dr[TABLE.Patient.VistaPatientId].ToString());
						}
						//
						drReport[TABLE.Patient.VistaPatientId] = dr[Common.DatabaseConstants.VistALinkColumnNames.VistaPatientId];
						drReport[TABLE.Patient.PatientGuid] = drPatient[TABLE.Patient.PatientGuid];
						drReport[ARTIFICIAL.PatientDisplayName] = BOL.Patient.BuildDisplayName(drPatient[TABLE.Patient.PatientFirstName].ToString(),
							drPatient[TABLE.Patient.PatientMiddleName].ToString(),
							drPatient[TABLE.Patient.PatientLastName].ToString());
						drReport[TABLE.Patient.DisplayVistaPatientId] = drPatient[TABLE.Patient.DisplayVistaPatientId];
						drReport[TABLE.Patient.PatientDeathDate] = drPatient[TABLE.Patient.PatientDeathDate];
						drReport[TABLE.PatientTreatment.PatientLocation] = drPatient[TABLE.PatientTreatment.PatientLocation];
						//
						drReport[TABLE.SpecimenTestThreshold.VistaLaboratoryTestName] = dr[Common.DatabaseConstants.VistALinkColumnNames.TestPrintName];
						drReport[TABLE.PatientTest.TestResult] = dr[Common.DatabaseConstants.VistALinkColumnNames.TestResult];
						drReport[TABLE.SpecimenTest.TestDate] = dr[Common.DatabaseConstants.VistALinkColumnNames.ResultDateTime];
						drReport[ARTIFICIAL.SortDate] = dr[Common.DatabaseConstants.VistALinkColumnNames.ResultDateTime];
						//
						dtReport.Rows.Add(drReport);
					}
				}
			}
			catch (BOL.BusinessObjectException)
			{
				//Nothing to do here.. but no test results will display on the report!
			}
			//
			foreach(DataRow dr in _transfusedUnits.Rows)
			{
				//Ignore patient transfusion record if no lab test result returned for the patient
				if (patientLabTestArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
				{
					continue;
				}
				//
				DataRow drReport = dtReport.NewRow();
				//
				string name = BOL.Patient.BuildDisplayName(dr[TABLE.Patient.PatientFirstName].ToString(),
					dr[TABLE.Patient.PatientMiddleName].ToString(),
					dr[TABLE.Patient.PatientLastName].ToString());
				//
				drReport[TABLE.Patient.PatientGuid] = dr[TABLE.Patient.PatientGuid];
				drReport[ARTIFICIAL.PatientDisplayName] = name;
				drReport[TABLE.Patient.DisplayVistaPatientId] = dr[TABLE.Patient.DisplayVistaPatientId];
				drReport[TABLE.Patient.PatientDeathDate] = dr[TABLE.Patient.PatientDeathDate];
				drReport[TABLE.PatientTreatment.PatientLocation] = dr[TABLE.PatientTreatment.PatientLocation];
				//
				drReport[TABLE.BloodUnit.EyeReadableUnitId] = dr[TABLE.BloodUnit.EyeReadableUnitId];
				drReport[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName]+", "+
					BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(dr[TABLE.BloodUnit.LabelTypeCode]),dr[TABLE.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(dr[TABLE.DonationType.DonationTypeCode]),dr[TABLE.BloodUnit.UnitDivisionId].ToString());
				//
				if (!dr.IsNull(ARTIFICIAL.PooledUnitsCount))
				{
					if (Convert.ToInt32(dr[ARTIFICIAL.PooledUnitsCount])>0)
					{
						drReport[TABLE.BloodProduct.ProductShortName] = drReport[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[ARTIFICIAL.PooledUnitsCount].ToString()+")";
					}
				}
				//
				drReport[TABLE.PatientTransfusion.TransfusionEndDateTime] = dr[TABLE.PatientTransfusion.TransfusionEndDateTime];
				drReport[ARTIFICIAL.SortDate] = dr[TABLE.PatientTransfusion.TransfusionEndDateTime];
				//
				dtReport.Rows.Add(drReport);
			}
			//
			string sortString = ARTIFICIAL.PatientDisplayName+" ASC, "+
				TABLE.Patient.DisplayVistaPatientId+", "+
				ARTIFICIAL.SortDate+" DESC, "+
				TABLE.BloodUnit.EyeReadableUnitId+", "+
				TABLE.BloodProduct.ProductShortName;
			//
			DataRow[] drSort = dtReport.Select("",sortString);
			this._transfusionComplictionsReport = dtReport.Clone();
			foreach (DataRow drSorted in drSort)
			{
				this._transfusionComplictionsReport.Rows.Add(drSorted.ItemArray);
			}
		}

		private bool IncludeTestInReport(DataRow drTest)
		{
			DataRow[] drThreshold = this._labTests.Select(TABLE.SpecimenTestThreshold.LabTestId+" = '"+drTest[TABLE.SpecimenTestThreshold.LabTestId].ToString()+"'");
			//
			if ((drThreshold == null) || (drThreshold.Length==0))
			{
				// Test not in the list, so ignore
				return false;
			}
			//
			string threshold = drThreshold[0][TABLE.SpecimenTestThreshold.ThresholdResult].ToString();
			//CR 3194, change to upper in case teh vista lab results are expected in camel case for example
			//HBsAB expects a result of Reactive and VBECS is configured with REACTIVE
			string testResult = drTest[Common.DatabaseConstants.VistALinkColumnNames.TestResult].ToString().ToUpper();
			//
			if (threshold.Trim().Length == 0)
			{
				// No threshold, so always include test
				return true;
			}
			else if (Common.RegularExpressions.Threshold().IsMatch(threshold))
			{
				// CR 2252
				if (Common.RegularExpressions.IntegerOrDecimal().IsMatch(testResult)) 
				{
					// Numeric threshold
					if (threshold.StartsWith("<"))
					{
						threshold = threshold.Replace("<", "").Trim();
						return (Convert.ToDecimal(testResult) < Convert.ToDecimal(threshold));
					}
					else
					{
						threshold = threshold.Replace(">", "").Trim();
						return (Convert.ToDecimal(testResult) > Convert.ToDecimal(threshold));
					}
				}
				else
				{
					// Include test if threshold is numeric but non-numeric results were obtained
					return true;
				}
			}
			else if (Common.RegularExpressions.ThresholdText().IsMatch(threshold))
			{
				// Look for test result in string of positive results
				return (threshold.IndexOf(testResult) > -1);
			}
			//
			return false;
		}

		private ArrayList GetPatientArray()
		{
			ArrayList patientArray = new ArrayList();
			//
			foreach(DataRow dr in _transfusedUnits.Rows)
			{
				if (patientArray.IndexOf(dr[TABLE.Patient.VistaPatientId].ToString())<0)
				{
					patientArray.Add(dr[TABLE.Patient.VistaPatientId].ToString());
				}
			}
			//
			return patientArray;
		}

		private void GetLabTests()
		{
			BOL.LabTest labTest = new BOL.LabTest();
			labTest.ReportType = Common.ReportType.TransfusionComplication;
			DataTable allLabTests = labTest.GetLabTests();
			//
			_labTests = allLabTests.Clone();
			_labTestArray = new ArrayList();
			//
			foreach(DataRow dr in allLabTests.Rows)
			{
				if (Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.SpecimenTestThreshold.RecordStatusCode].ToString()) == Common.RecordStatusCode.Active)
				{
					_labTests.Rows.Add(dr.ItemArray);
					_labTestArray.Add(dr[TABLE.SpecimenTestThreshold.LabTestId].ToString().Trim());
				}
			}
		}

		private DataRow FindPatientInfo(string vistaPatientID)
		{
			DataRow[] drPatients = this._transfusedUnits.Select(TABLE.Patient.VistaPatientId+" = '"+vistaPatientID+"'");
			//
			if (drPatients == null)
			{
				throw new BOL.BusinessObjectException("Patient has no transfused units");
			}
			//
			return drPatients[0];
		}

		private DataTable GetTransfusionComplicationsReportSchema()
		{
			DataTable dt = new DataTable("TransfusionComplicationsReport");
			dt.Columns.Add(TABLE.Patient.VistaPatientId);
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.PatientDisplayName);
			dt.Columns.Add(TABLE.Patient.DisplayVistaPatientId);
			dt.Columns.Add(TABLE.Patient.PatientDeathDate, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientTreatment.PatientLocation);
			dt.Columns.Add(TABLE.BloodUnit.EyeReadableUnitId);
			dt.Columns.Add(TABLE.BloodProduct.ProductShortName);
			dt.Columns.Add(TABLE.PatientTransfusion.TransfusionEndDateTime, typeof(DateTime));
			dt.Columns.Add(TABLE.SpecimenTestThreshold.VistaLaboratoryTestName);
			dt.Columns.Add(TABLE.PatientTest.TestResult);
			dt.Columns.Add(TABLE.SpecimenTest.TestDate, typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.SortDate, typeof(DateTime));
			return dt;
		}

		#endregion

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7845"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7846"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GenerateReport
		/// </summary>
		/// <returns></returns>
		public DataSet GenerateReport()
		{
			this.GetTransfusionComplicationsReport();

			DataSet reportDataSet = new DataSet();
			reportDataSet.Tables.Add(this.DetailedReport.Copy());
			reportDataSet.Tables.Add(this._labTests.Copy());
			//
			return reportDataSet;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7847"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7848"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            _dsReport = this.GenerateReport();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionComplicationsDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionComplications.TransfusionComplicationsReport.rdlc");
            Stream streamThresholds = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionComplications.TransfusionComplicationThresholds.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("TransfusionComplicationThresholds", streamThresholds);

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionComplicationThresholds" || e.DataSourceNames[0].ToString() == "TransfusionComplicationThresholdsDataSet")
            {
                ReportDataSource reportTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportTests.Name = "TransfusionComplicationThresholdsDataSet";
                    reportTests.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportTests);
            }
        }
	}
}
